/*
 * Decompiled with CFR 0.152.
 */
package com.zkryle.jeg.common.events;

import com.zkryle.jeg.common.golem.EnragedMagmaticGolemEntity;
import com.zkryle.jeg.common.golem.MagmaticGolemEntity;
import com.zkryle.jeg.common.golem.PlantGolemEntity;
import com.zkryle.jeg.common.tileentities.ChargingTableTileEntity;
import com.zkryle.jeg.core.Config;
import com.zkryle.jeg.core.Init;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.monster.ZombifiedPiglinEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="justenoughgolems", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class StaticEventSubscriber {
    @SubscribeEvent
    public static void onGolemPlaced(BlockEvent.EntityPlaceEvent event) {
        BlockPos blockBelow;
        BlockPos pumpkin;
        World level = (World)event.getWorld();
        BlockPos pos = event.getPos();
        Block block = event.getState().func_177230_c();
        if (block == Blocks.field_196625_cS) {
            pumpkin = pos;
            blockBelow = pos.func_177977_b();
        } else {
            pumpkin = pos.func_177984_a();
            blockBelow = pos;
        }
        UUID ownerUUID = null;
        if (event.getEntity() instanceof PlayerEntity) {
            ownerUUID = ((PlayerEntity)event.getEntity()).func_110124_au();
        }
        StaticEventSubscriber.spawnPlantGolem(level, blockBelow, pumpkin, ownerUUID);
        StaticEventSubscriber.spawnMagmaticGolem(level, blockBelow, pumpkin, event.getEntity());
    }

    @SubscribeEvent
    public static void onGolemShears(PlayerInteractEvent.RightClickBlock event) {
        if (event.getPlayer().func_184614_ca().func_77973_b() == Items.field_151097_aZ && event.getWorld().func_180495_p(event.getPos()).func_177230_c() == Blocks.field_150423_aK) {
            Direction facing = event.getPlayer().func_174811_aO().func_176734_d();
            event.getWorld().func_180501_a(event.getPos(), (BlockState)Blocks.field_196625_cS.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)facing), 3);
            event.setCanceled(true);
            event.getWorld().func_184134_a((double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p(), SoundEvents.field_199059_fV, SoundCategory.BLOCKS, 1.0f, 1.0f, true);
            event.getPlayer().func_184614_ca().func_222118_a(1, (LivingEntity)event.getPlayer(), p -> p.func_213334_d(Hand.MAIN_HAND));
            StaticEventSubscriber.spawnPlantGolem(event.getWorld(), event.getPos().func_177977_b(), event.getPos(), event.getPlayer().func_110124_au());
        }
    }

    private static void spawnPlantGolem(World level, BlockPos blockBelow, BlockPos pumpkin, @Nullable UUID owner) {
        if (level.func_180495_p(blockBelow).func_177230_c() == Init.PRECIOUS_MOSSY_COBBLESTONE.get() && level.func_180495_p(pumpkin).func_177230_c() == Blocks.field_196625_cS) {
            level.func_175655_b(pumpkin, false);
            level.func_175655_b(blockBelow, false);
            PlantGolemEntity plantGolem = PlantGolemEntity.createGolem(owner, level);
            plantGolem.func_70107_b((double)blockBelow.func_177958_n() + 0.5, blockBelow.func_177956_o(), (double)blockBelow.func_177952_p() + 0.5);
            level.func_217376_c((Entity)plantGolem);
        }
    }

    private static void spawnMagmaticGolem(World level, BlockPos blockBelow, BlockPos pumpkin, Entity pEntity) {
        if (level.func_180495_p(blockBelow).func_177230_c() == Init.MAGMATIC_OBSIDIAN.get() && level.func_180495_p(pumpkin).func_177230_c() == Blocks.field_196625_cS) {
            level.func_175655_b(pumpkin, false);
            level.func_175655_b(blockBelow, false);
            MagmaticGolemEntity magmaticGolemEntity = MagmaticGolemEntity.createMagmaticGolemEntity(level);
            magmaticGolemEntity.func_70107_b((double)blockBelow.func_177958_n() + 0.5, blockBelow.func_177956_o(), (double)blockBelow.func_177952_p() + 0.5);
            level.func_217376_c((Entity)magmaticGolemEntity);
            if (pEntity instanceof PlayerEntity) {
                magmaticGolemEntity.setOn(false);
                magmaticGolemEntity.setTamed((PlayerEntity)pEntity);
            }
        }
    }

    @SubscribeEvent
    public static void checkExplosionMagmaticGolem(LivingAttackEvent event) {
        if (event.getEntity() instanceof MagmaticGolemEntity && ((MagmaticGolemEntity)event.getEntity()).isTransforming) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void addEnragedMagmaticGolemAsTarget(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ZombieEntity && !(entity instanceof ZombifiedPiglinEntity)) {
            ((ZombieEntity)entity).field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)((ZombieEntity)entity), EnragedMagmaticGolemEntity.class, true));
        } else if (entity instanceof AbstractSkeletonEntity && !(entity instanceof WitherSkeletonEntity)) {
            ((AbstractSkeletonEntity)entity).field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)((AbstractSkeletonEntity)entity), EnragedMagmaticGolemEntity.class, true));
        } else if (entity instanceof CreeperEntity) {
            ((CreeperEntity)entity).field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)((CreeperEntity)entity), EnragedMagmaticGolemEntity.class, true));
        } else if (entity instanceof SpiderEntity) {
            ((SpiderEntity)entity).field_70715_bh.func_75776_a(3, (Goal)new SpiderEntity.TargetGoal((SpiderEntity)entity, EnragedMagmaticGolemEntity.class));
        } else if (entity instanceof AbstractRaiderEntity) {
            ((AbstractRaiderEntity)entity).field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)((AbstractRaiderEntity)entity), EnragedMagmaticGolemEntity.class, true));
        } else if (entity instanceof SlimeEntity) {
            ((SlimeEntity)entity).field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)((SlimeEntity)entity), EnragedMagmaticGolemEntity.class, true));
        }
    }

    @SubscribeEvent
    public static void onBlockInteraction(PlayerInteractEvent.RightClickBlock event) {
        if (event.getWorld().func_180495_p(event.getPos()).func_177230_c() == Blocks.field_235399_ni_ && event.getPlayer().func_184586_b(event.getHand()).func_77973_b() == Items.field_151129_at && !event.getPlayer().func_225608_bj_()) {
            event.getWorld().func_175656_a(event.getPos(), ((Block)Init.MAGMATIC_OBSIDIAN.get()).func_176223_P());
            event.getPlayer().func_184611_a(event.getHand(), new ItemStack((IItemProvider)Items.field_151133_ar));
            event.getPlayer().func_184609_a(event.getHand());
            event.getWorld().func_184133_a(event.getPlayer(), event.getPos(), SoundEvents.field_187627_L, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        if (event.getName() == null) {
            return;
        }
        if (((Boolean)Config.SHOULD_MAGMATIC_GOLEM_SPAWN.get()).booleanValue() && event.getCategory().equals((Object)Biome.Category.NETHER)) {
            event.getSpawns().func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)Init.MAGMATIC_GOLEM_ENTITY.get(), ((Integer)Config.MAGMATIC_GOLEM_ENTITY_WEIGHT.get()).intValue(), 1, 1));
        }
    }

    @SubscribeEvent
    public static void blockBroken(BlockEvent.BreakEvent event) {
        ChargingTableTileEntity te;
        if (event.getWorld().func_175625_s(event.getPos()) instanceof ChargingTableTileEntity && (te = (ChargingTableTileEntity)event.getWorld().func_175625_s(event.getPos())).getCore() != null) {
            event.getWorld().func_217376_c((Entity)new ItemEntity((World)event.getWorld(), (double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p(), te.getCore()));
        }
    }
}

